package com.example.bytesbee.alphabets.activities;

import android.app.Activity;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.daimajia.androidanimations.library.Techniques;
import com.daimajia.androidanimations.library.YoYo;
import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.utils.SessionManager;
import com.example.bytesbee.alphabets.activities.utils.Utils;

public class BaseActivity extends AppCompatActivity {

    public Activity mActivity;
    public SessionManager session;
    private MediaPlayer mediaPlayer;
    public ImageView btnPrevious, btnNext, play, btnSound;

//    @Override
//    public void onWindowFocusChanged(boolean hasFocus) {
//        super.onWindowFocusChanged(hasFocus);
//        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
//            //if (hasFocus) {
//            getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//                    | View.SYSTEM_UI_FLAG_FULLSCREEN
//                    | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
//            //} | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
//        }
//    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivity = this;
        session = new SessionManager(mActivity);

        try {
            btnPrevious = findViewById(R.id.btnPrev);
            btnNext = findViewById(R.id.btnNext);
            play = findViewById(R.id.play);
            btnSound = findViewById(R.id.btnSound);

            if (session.isSoundOn()) {
                btnSound.setImageResource(R.drawable.ic_sound_on);
            } else {
                btnSound.setImageResource(R.drawable.ic_sound_off);
            }

            btnSound.setOnClickListener(v -> {
                if (session.isSoundOn()) {
                    btnSound.setImageResource(R.drawable.ic_sound_off);
                } else {
                    btnSound.setImageResource(R.drawable.ic_sound_on);
                }
                session.setOnOffSound(!session.isSoundOn());
            });
        } catch (Exception ignored) {

        }
    }

    // Play audio
    public void playAudio(int paramInt) {
        stopAudio();

        if (session.isVibrateOn()) {
            Utils.setVibrate(mActivity);
        }

        if (session.isSoundOn()) {
            try {
                if (this.mediaPlayer != null)
                    this.mediaPlayer.reset();
                this.mediaPlayer = MediaPlayer.create(this, paramInt);
                this.mediaPlayer.setScreenOnWhilePlaying(true);
                this.mediaPlayer.start();
            } catch (Exception e) {
                Utils.getErrors(e);
            }
        }
    }

    // Stop audio
    private void stopAudio() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying())
                    this.mediaPlayer.stop();
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
        } catch (Exception ignored) {
        }
    }

    public void bounceView(View imgView) {
        try {
            if (imgView instanceof ImageView)
                YoYo.with(Techniques.Bounce).duration(1000).playOn(imgView);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
        try {
            if (imgView instanceof TextView)
                YoYo.with(Techniques.FadeInUp).duration(1000).playOn(imgView);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
